document.getElementById('chatForm').onsubmit = async function(event) {
	event.preventDefault();
	const formData = new FormData();
	const userPrompt = document.getElementById('userPrompt').value;
	const fileInput = document.getElementById('knowledgeBaseFile');

	formData.append('userPrompt', userPrompt);
	if (fileInput.files[0]) {
		formData.append('knowledgeBaseFile', fileInput.files[0]);
	}

	const response = await fetch('bubble_chat.php', {
		method: 'POST',
		body: formData,
	});
	const data = await response.json();

	const chatMessages = document.getElementById('chatMessages');
	chatMessages.innerHTML += `<div><u><strong>You:</strong> ${userPrompt}</u></div>`;
	chatMessages.innerHTML += `<div style="padding:16px 0;"><strong>Bot:</strong> ${data.message}</div>`;

	// 日本語での読み上げ機能を追加
	// speakJapanese(data.message);

	// 日本語での読み上げ機能を追加（条件付き）
	if (document.getElementById('voiceEnabled').checked) {
		speakJapanese(data.message);
	}

	document.getElementById('userPrompt').value = ''; // Clear input
	document.getElementById('knowledgeBaseFile').value = ''; // ファイル選択をクリア
};

document.getElementById('knowledgeBaseFile').addEventListener('change', function() {
	var fileName = this.files[0] ? this.files[0].name : "なし";
	document.getElementById('uploadedFileName').innerText = fileName;
});

document.getElementById('clearChat').addEventListener('click', function() {
	// チャットメッセージをクリア
	document.getElementById('chatMessages').innerHTML = '';
	// プロンプト入力欄をクリア
	document.getElementById('userPrompt').value = '';
	// アップロードされたファイル情報をクリア
	document.getElementById('knowledgeBaseFile').value = '';
	// アップロードされたファイル名表示を「なし」にリセット
	document.getElementById('uploadedFileName').innerText = "なし";
	// ファイル選択フィールドを再表示（必要に応じて）
});

// 日本語のテキストを読み上げる関数
function speakJapanese(text) {
	const utterance = new SpeechSynthesisUtterance(text);
	utterance.lang = 'ja-JP'; // 言語を日本語に設定
	speechSynthesis.speak(utterance);
}
// 音声読み上げのオン・オフを切り替える機能（追加部分）
document.getElementById('voiceEnabled').addEventListener('change', function() {
	// ここには特に何も記述しなくても良いが、状態が変わったことを何かしらの方法でユーザーに通知することもできる
});
// 音声停止ボタンのイベントリスナーを設定
document.getElementById('stopVoice').addEventListener('click', function() {
	// 現在の音声読み上げを停止
	window.speechSynthesis.cancel();
});

document.getElementById('clearChat').addEventListener('click', async function() {
	// チャットメッセージをクリア
	document.getElementById('chatMessages').innerHTML = '';
	// プロンプト入力欄をクリア
	document.getElementById('userPrompt').value = '';
	// アップロードされたファイル情報をクリア
	document.getElementById('knowledgeBaseFile').value = '';
	// アップロードされたファイル名表示を「なし」にリセット
	document.getElementById('uploadedFileName').innerText = "なし";

	// サーバーのセッション情報をクリアするリクエストを送信
	await fetch('bubble_session_reset.php', {
		method: 'POST'
	}).then(response => response.json())
	.then(data => console.log(data.message))
	.catch(error => console.error('Error:', error));
});
// チャットウインドウの開閉
document.getElementById('closeChatWindow').addEventListener('click', function() {
	document.getElementById('chatWindow').style.display = 'none';
});
document.getElementById('openChatWindow').addEventListener('click', function() {
	document.getElementById('chatWindow').style.display = 'flex'; // または 'flex'
});