<?php

// 作成者: Hirofumi Yokohata
// 作成日: 2024-02-22

session_start();
require_once '../../data/ai/apikey/config.php'; // APIキーの読み込み
$apiKey = OPENAI_API_KEY;
$apiUrl = 'https://api.openai.com/v1/chat/completions';

//header('Content-Type: application/json');

// ファイルアップロードの処理
if (!empty($_FILES['knowledgeBaseFile']['name']) && !isset($_SESSION['knowledgeBase'])) {
	if ($_FILES['knowledgeBaseFile']['size'] > 1000000 || $_FILES['knowledgeBaseFile']['type'] !== 'text/plain') {
		echo json_encode(['message' => 'エラー: 不正なファイルです。']);
		exit;
	}
	$fileContent = file_get_contents($_FILES['knowledgeBaseFile']['tmp_name']);
	$_SESSION['knowledgeBase'] = $fileContent;
	$_SESSION['uploadedFileName'] = $_FILES['knowledgeBaseFile']['name'];
}

$userPrompt = filter_input(INPUT_POST, 'userPrompt', FILTER_SANITIZE_STRING);
$knowledgeBase = $_SESSION['knowledgeBase'] ?? '';

$data = [
	'model' => 'gpt-3.5-turbo',
	'max_tokens' => 256,
	'messages' => [
		['role' => 'system', 'content' => 'You are a helpful assistant.'],
		['role' => 'user', 'content' => $knowledgeBase . " " . $userPrompt],
	],
	'temperature' => 0.5
];

// JSON内容のログ記録（リクエスト）
$requestJson = json_encode($data, JSON_PRETTY_PRINT);
error_log("送信するJSONデータ: " . $requestJson);

$headers = [
	'Content-Type: application/json',
	'Authorization: Bearer ' . $apiKey,
];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $requestJson);
$response = curl_exec($ch);

if ($response === false) {
	$error_msg = curl_error($ch);
	echo json_encode(['message' => 'APIリクエストに失敗しました: ' . $error_msg]);
	curl_close($ch);
	exit;
}

$status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($status_code != 200) {
	// HTTPステータスコードが200以外の場合、エラーとして扱う
	echo json_encode(['message' => "APIリクエストに失敗しました。ステータスコード: $status_code", 'response' => json_decode($response, true)]);
	exit;
}

// JSON内容のログ記録（レスポンス）
$responseJson = json_encode(json_decode($response, true), JSON_PRETTY_PRINT);
error_log("受信したJSONデータ: " . $responseJson);

$responseArray = json_decode($response, true);
$responseText = $responseArray['choices'][0]['message']['content'] ?? '応答を取得できませんでした。';

// 応答テキストをJSONとしてエンコードして返す
echo json_encode(['message' => $responseText]);

?>